#pragma once
#include "Block.h"
#include "Coin.h"
#include "Pipe.h"
#include "Pole.h"
#include "Flag.h"
#include "Castle.h"
#include "Cloud.h"
#include "Bush.h"
#include "Hill.h"
#include "GameItems.h"

//The purpose of ItemManager is to create and render each item present in the game that are generated from the tile map

class ItemManager
{
public:

	ItemManager();
	~ItemManager();

	//Function overloading
	void createItem(Block* block, GameItems::BlockType type, GameItems::StoredItems item, sf::Vector2f spawn);	//Create a block, of BlockType type, which stores item, at the location spawn
	void createItem(SizeableItem* item, GameItems::SpriteSize size, sf::Vector2f spawn);	//Create a SizeableItem, of SpriteSize size at the location spawn
	void createItem(GameItems* item, sf::Vector2f spawn);	//Create a GameItem at the location spawn

	void update(float dt, Mario* mario);
	void render(sf::RenderWindow* window);

	std::vector<GameItems*> getItems();	//Get the gameItems vector

private:
	std::vector<GameItems*> gameItems;	//The gameItems vector stores all gameItems present in the level
};

